from wiki.api_v2.exceptions import AlreadyExists
from wiki.favorites.management.commands.sync_favorites_v2 import do_sync as sync_favorites
from wiki.org import get_user_orgs
from wiki.subscriptions.management.commands.logic_migration_from_page_watch import migrate_page_watches_to_subscriptions
from wiki.users.consts import UserFeatureStatus


def handle_feature(feature, next_status):
    if next_status == UserFeatureStatus.ENABLED:
        for org in get_user_orgs(feature.user, assert_empty_org=False):
            sync_favorites(feature.user, org)
            try:
                migrate_page_watches_to_subscriptions(feature.user, org)
            except AlreadyExists:
                pass

    feature.status = next_status
    feature.save()
