from wiki.intranet.models import Staff
from wiki.org import get_org, org_staff


def get_users_cluster_tag(self, login):
    from wiki.pages.models import Page
    from wiki.utils.supertag import translit

    # Return "users/LOGIN" if such page exists (it should)
    supertag = 'users/' + translit(login)
    if Page.objects.filter(supertag=supertag, org=get_org()).exists():
        return supertag

    # If not found, return "WikiName" if such page exists (it might)
    wiki_name = get_staff_wiki_name(login)
    if wiki_name and Page.objects.filter(tag=wiki_name, org=get_org()).exists():
        return translit(wiki_name, False)

    # If nothing found, return what should exist
    return supertag


def get_staff_wiki_name(username):
    try:
        staff = org_staff().values('wiki_name').get(login=username)
    except (Staff.DoesNotExist, Staff.MultipleObjectsReturned):
        return None
    return staff.get('wiki_name', None)
