from django.conf import settings
from django.contrib import admin
from django.contrib.auth import get_user_model
from django.contrib.auth.models import Group as DjangoGroup

from wiki.users.admin_forms import GroupAdminExternal, UserAdminExternal
from wiki.users_biz.models import Group, GroupRelationship

User = get_user_model()


class GroupRelationshipInline(admin.StackedInline):
    model = GroupRelationship
    fk_name = 'from_group'


class GroupAdmin(admin.ModelAdmin):
    inlines = [GroupRelationshipInline]


if settings.IS_BUSINESS:
    admin.site.register(Group, GroupAdmin)
    admin.site.register(User, UserAdminExternal)
    admin.site.unregister(DjangoGroup)
    admin.site.register(DjangoGroup, GroupAdminExternal)
    admin.site.unregister(Group)
    admin.site.register(Group, GroupAdmin)
