import logging

from django.core.management.base import BaseCommand

from wiki.sync.connect.dir_client import DirClient
from wiki.users_biz.signals import edit_dir_user

logger = logging.getLogger(__name__)

dir_client = DirClient()


def handle_if_role_changed(event):
    diff = event['content']['diff']
    if 'role' in diff:
        edit_dir_user(sender=None, object=event['object'], content=event['content'])


def do_import(dir_org_id):
    # в дальнейшем, мб придется прогонять еще про другие события о которых мы не знаем
    events = [
        ('user_property_changed', handle_if_role_changed),
    ]
    results = {}

    for event_name, handler in events:
        event_list = dir_client.get_events(dir_org_id, name=event_name)
        results[event_name] = len(event_list)
        for event in event_list:
            handler(event)

    logger.info('Events applied: %s' % results)


class Command(BaseCommand):
    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('--dir_org_id', dest='dir_org_id', required=True, help='Organization ID in Directory')

    def handle(self, *args, **options):
        dir_org_id = options.get('dir_org_id')
        do_import(dir_org_id)
