
from django.core.management import BaseCommand, CommandError

from wiki.sync.connect.dir_client import DirClient


class Command(BaseCommand):
    """
    Удалить подписку на события в Директории с переданным ID.
    """

    help = 'Delete subscription in Directory with specified ID'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--subscription_id',
            '-id',
            action='store',
            dest='subscription_id',
            help='Subscription ID. Specify ID of subscription in Directory',
        )

    def handle(self, *args, **options):
        subscription_id = options.get('subscription_id')

        if not subscription_id:
            raise CommandError('subscription_id parameter is required')

        DirClient().delete_subscription(subscription_id)
