
from wiki.sync.connect.org_ctx import get_org
from wiki.sync.connect.models import Organization
from wiki.org import org_ctx, org_group
from wiki.sync.connect.dir_client import DirClient
from wiki.users_biz.models import Group, GROUP_TYPES


"""
Починить вложенность департаментов, см. детали в тикете https://st.yandex-team.ru/WIKI-10730
"""


dir_client = DirClient()


def run(dir_org_id=None):
    if dir_org_id:
        orgs = [Organization.objects.get(dir_id=dir_org_id)]
    else:
        orgs = Organization.objects.filter(status='enabled')

    for org in orgs:
        with org_ctx(org):
            deps, _ = dir_client.get_departments(org.dir_id)
            for dir_dep in deps:
                dep = get_department(dir_dep['id'])
                if dep and len(dep.get_ancestors()) == 0 and dir_dep.get('parent'):
                    parent_dep = get_department(dir_dep['parent'].get('id'))
                    if parent_dep:
                        dep.add_relation_to_parent(parent_dep)


def get_department(dir_id):
    try:
        return org_group().get(dir_id=dir_id, group_type=GROUP_TYPES.department)
    except Group.DoesNotExist:
        print('Department with dir_id={} in org with dir_org_id={} not found'.format(dir_id, get_org().dir_id))
        return None
