# Generated by Django 1.9.9 on 2016-09-23 19:45


from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0007_alter_validators_add_error_messages'),
        ('users_biz', '0002_auto_20160830_1937'),
    ]

    operations = [
        migrations.CreateModel(
            name='Group',
            fields=[
                (
                    'group_ptr',
                    models.OneToOneField(
                        auto_created=True,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to='auth.Group',
                        on_delete=models.CASCADE,
                    ),
                ),
                ('dir_id', models.CharField(max_length=16)),
                ('group_type', models.PositiveIntegerField(choices=[(0, b'group'), (1, b'department')])),
            ],
            options={
                'db_table': 'auth_group_extra',
            },
            bases=('auth.group',),
        ),
        migrations.CreateModel(
            name='GroupRelationship',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                (
                    'from_group',
                    models.ForeignKey(
                        related_name='from_group', to='users_biz.Group', on_delete=models.CASCADE
                    ),
                ),
                (
                    'to_group',
                    models.ForeignKey(
                        related_name='to_group', to='users_biz.Group', on_delete=models.CASCADE
                    ),
                ),
            ],
            options={
                'db_table': 'auth_group_relationship',
            },
        ),
        migrations.AddField(
            model_name='user',
            name='dir_id',
            field=models.CharField(max_length=16, null=True, unique=True),
        ),
        migrations.AddField(
            model_name='group',
            name='parents',
            field=models.ManyToManyField(
                related_name='related_to', through='users_biz.GroupRelationship', to='users_biz.Group'
            ),
        ),
        migrations.AlterUniqueTogether(
            name='group',
            unique_together=set([('dir_id', 'group_type')]),
        ),
    ]
