

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('users_biz', '0005_add_group_dir_type'),
    ]

    operations = [
        migrations.AlterField(
            model_name='user',
            name='username',
            field=models.CharField(
                error_messages={'unique': 'A user with that username already exists.'},
                help_text='Required. 200 characters or fewer. Letters, digits and @/./+/-/_ only.',
                max_length=200,
                unique=True,
                validators=[
                    django.core.validators.RegexValidator(
                        '^[\\w.@+-]+$',
                        'Enter a valid username. This value may contain only letters, numbers and @/./+/-/_ characters.',
                    )
                ],
                verbose_name='username',
            ),
        ),
        migrations.AlterField(
            model_name='user',
            name='first_name',
            field=models.CharField(
                blank=True,
                help_text='Required. 200 characters or fewer. Letters, digits and @/./+/-/_ only.',
                max_length=200,
                verbose_name='first name',
            ),
        ),
        migrations.AlterField(
            model_name='user',
            name='last_name',
            field=models.CharField(
                blank=True,
                help_text='Required. 200 characters or fewer. Letters, digits and @/./+/-/_ only.',
                max_length=200,
                verbose_name='last name',
            ),
        ),
    ]
