

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('users_biz', '0010_add_label_to_group'),
    ]

    operations = [
        # Убираем unique=True, добавляем db_index=True.
        migrations.AlterField(
            model_name='user',
            name='username',
            field=models.CharField(
                help_text='Required. 200 characters or fewer. Letters, digits and @/./+/-/_ only.',
                db_index=True,
                max_length=200,
                validators=[
                    django.core.validators.RegexValidator(
                        '^[\\w.@+-]+$',
                        'Enter a valid username. This value may contain only letters, numbers and @/./+/-/_ characters.',
                    )
                ],
                verbose_name='username',
            ),
        ),
    ]
