

from django.db import migrations


def remove_empty_personal_clusters(apps, schema_editor):
    # Удалить домашний кластер пользователя (автосгенеренные страницы), если он им ни разу не пользовался,
    # т.е. не редактировал и не создавал ни одной страницы.
    User = apps.get_model('users_biz', 'User')
    Page = apps.get_model('pages', 'Page')
    Pageevent = apps.get_model('notifications', 'PageEvent')

    deleted_clusters_count = 0
    users = User.objects.all()
    for user in users:
        for org in user.orgs.all():
            try:
                user_cluster = Page.objects.get(supertag='users/%s' % user.username, org=org, pageevent__isnull=True)
                if Pageevent.objects.filter(page__supertag='users/%s/notes' % user.username, page__org=org).count() > 1:
                    # если пользователь редактировал свои заметки, то удалять ничего не будем
                    continue

                if (
                    Page.objects.filter(supertag__istartswith='users/%s/' % user.username, org=org)
                    .exclude(supertag='users/%s/notes' % user.username)
                    .exists()
                ):
                    # у пользователя есть созданные им страницы в домашнем кластере - ничего удалять не будем
                    continue

                user_cluster.delete()
                deleted_clusters_count += 1
                Page.objects.get(supertag='users/%s/notes' % user.username, org=org).delete()
            except Page.DoesNotExist:
                # пользователь уже редактировал свою домашнюю страницу или у него нет страницы заметок
                pass

    print('Migration finished: %s personal clusters was deleted.' % deleted_clusters_count)


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('users_biz', '0012_user_has_personal_cluster'),
    ]

    operations = [
        migrations.RunPython(remove_empty_personal_clusters, reverse_code=reverse_func),
        migrations.RunSQL(
            'UPDATE auth_user AS au '
            'SET has_personal_cluster = True '
            'FROM auth_user_orgs AS org '
            'WHERE au.id = org.user_id '
            'AND EXISTS '
            '(SELECT * FROM pages_page AS pp '
            "WHERE pp.supertag = concat('users/', username) AND pp.org_id = org.organization_id) "
            'AND EXISTS '
            '(SELECT * FROM pages_page AS pp '
            "WHERE pp.supertag = concat('users/', username, '/notes') AND pp.org_id = org.organization_id);",
            reverse_sql='UPDATE auth_user SET has_personal_cluster = False ',
        ),
    ]
