

from django.db import migrations

from wiki.pages.api import create_event
from wiki.pages.models import Page, Revision
from wiki.utils.supertag import translit


def create_missing_pageevent(supertag, org):
    try:
        page = Page.objects.get(supertag=supertag, org_id=org.id)
        if not page.pageevent_set.filter(event_type=1).exists():
            rev = Revision.objects.filter(page_id=page.id).order_by('id')[0]
            create_event(True, page, rev)
    except Page.DoesNotExist:
        pass


def check_personal_clusters_pageevents(apps, schema_editor):
    """
    Проверить наличие события о создании страницы у всех автоматически создаваемых пользовательских страниц
    (корневые страницы личных пользовательских кластеров, а также страницы заметок) и в случае отсутствия создать
    запись в таблице notifications_pageevent с типом event_type=1 (create).
    """
    User = apps.get_model('users_biz', 'User')

    users = User.objects.all()
    for user in users:
        for org in user.orgs.all():
            create_missing_pageevent(translit('users/%s' % user.username), org)
            create_missing_pageevent(translit('users/%s/notes' % user.username), org)


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('users_biz', '0013_remove_empty_personal_clusters'),
    ]

    operations = [
        migrations.RunPython(check_personal_clusters_pageevents, reverse_code=reverse_func),
    ]
