
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('users_biz', '0015_add_cloud_uid'),
    ]

    operations = [
        # Использование GinIndex из django.contrib.postgres.indexes
        # генерит sql без gin_trgm_ops, поэтому используем RunSQL
        migrations.RunSQL(
            'CREATE INDEX CONCURRENTLY IF NOT EXISTS "auth_user_username_gin" \
            ON "auth_user" USING gin (username gin_trgm_ops)'
        ),
        migrations.RunSQL(
            'CREATE INDEX CONCURRENTLY IF NOT EXISTS "auth_group_extra_title_gin" \
            ON "auth_group_extra" using gin (title gin_trgm_ops)'
        )
    ]
