# flake8: noqa
# isort:skip_file
"""
@neofelis NB: этот модуль нужно полностью переписать. сейчас это куча циклических зависимостей:

get_dir_user зависит от  get_org_dir_id (dir_groups) а dir_groups зависит от get_dir_user,
get_dir_user зависит от  import_dir_user (dir_users) а dir_users зависит от dir_groups, который зависит от get_dir_user

все не ломается только из-за вот такого локального импорта в хвосте. Поэтому все проверки отключены.
"""

from wiki.users_biz.errors import UnknownDirOrgError


def get_dir_user(dir_id, ignore_does_not_exist_error=False, try_to_import_nonexistent_user=False):
    try:
        return get_user_model().objects.get(dir_id=dir_id)
    except get_user_model().DoesNotExist:
        if try_to_import_nonexistent_user:
            try:
                dir_org_id = get_org_dir_id()
                user = DirClient().get_user(dir_org_id, dir_id)
                user['org_id'] = dir_org_id
                import_dir_user(sender=None, object=user, content=None)
                return get_user_model().objects.get(dir_id=dir_id)
            except Exception:
                logger.warning('Can\'t import user with dir_id=%s', dir_id, exc_info=1)

        if not ignore_does_not_exist_error:
            raise UnknownDirUserError(f'User with dir_id={dir_id} does not exist')


def get_dir_organization(dir_id):
    try:
        return Organization.objects.get(dir_id=dir_id)
    except Organization.DoesNotExist:
        msg = 'Organization with dir_id=%s does not exist'
        logger.error(msg, dir_id)
        raise UnknownDirOrgError(msg % dir_id)


from wiki.users_biz.signals.dir_groups import *
from wiki.users_biz.signals.dir_users import *
from wiki.users_biz.signals.org_data import *
