

from django.conf import settings
from django.db.models import Q
from wiki.intranet.models import Staff

from wiki.users.models import Group

if settings.IS_INTRANET:
    from wiki.intranet.models import Department

# ID отдела внутренних сервисов, никогда не меняется
YANDEX_INFRA_INT_INTERNAL_ID = 201


def groups_by_ids(group_ids):
    """
    Вернуть список групп по переданным PK.

    @type group_ids: iterable
    """
    return Group.objects.filter(id__in=group_ids)


def groups_by_department_ids(department_ids):
    """
    Вернуть департаментные группы по переданным id департаментов.

    @type department_ids: iterable
    """
    return Group.objects.filter(department_id__in=department_ids)


def find_staff_models(q, limit):
    """
    Найти пользователей по строке q: если строка входит в login или first_name, или last_name.
    Достаются только поля id, uid, login, first_name, last_name.

    @type q: str
    @type limit: int
    @rtype: QuerySet
    """
    query = Q()
    for word in q.split():
        query &= Q(login__icontains=word) | Q(first_name__icontains=word) | Q(last_name__icontains=word)

    return (
        Staff.objects.filter(query)
        .values('id', 'uid', 'login', 'first_name', 'last_name')
        .order_by(
            'last_name',
            'first_name',
            'login',
        )[:limit]
    )


def departments_of_internal_services():
    """
    Вернуть предков группу интранет сервисов.

    @rtype: QuerySet
    """
    return Department.objects.get(id=YANDEX_INFRA_INT_INTERNAL_ID).get_descendants(include_self=True)


def find_wiki_group_models(q, limit):
    """
    Найти группы по строке q: если строка входит в name.

    @type q: str
    @type limit: int
    @rtype: QuerySet
    """
    query = Q()
    for word in q.split():
        query &= Q(name__icontains=word)

    return (
        Group.objects.filter(query)
        .values('id', 'name')
        .order_by(
            'name',
        )[:limit]
    )


def get_id_attr_name():
    """
    Вернуть имя атрибута в базе, который используется в качестве ID для данной сущности.
    """
    return 'pk'
