

from django.db import migrations

from wiki.pages.api import create_event
from wiki.pages.models import Page, Revision


def create_missing_pageevent(supertag):
    try:
        page = Page.objects.get(supertag=supertag)
        if not page.pageevent_set.filter(event_type=1).exists():
            rev = Revision.objects.filter(page_id=page.id).order_by('id').first()
            if rev:
                create_event(True, page, rev)
    except Page.DoesNotExist:
        pass


def check_personal_clusters_pageevents(apps, schema_editor):
    """
    Проверить наличие события о создании страницы у всех автоматически создаваемых пользовательских страниц
    (корневые страницы личных пользовательских кластеров, а также страницы заметок) и в случае отсутствия создать
    запись в таблице notifications_pageevent с типом event_type=1 (create).
    """
    User = apps.get_model('users_ynx', 'User')

    users = User.objects.all()
    for user in users:
        create_missing_pageevent('users/%s' % user.username)
        create_missing_pageevent('users/%s/notes' % user.username)


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('users_ynx', '0004_user_has_personal_cluster'),
    ]

    operations = [
        migrations.RunPython(check_personal_clusters_pageevents, reverse_code=reverse_func),
    ]
