import time

from django.core.cache import caches


def benchmark(cache_names):
    for cache_name in cache_names:
        cache = caches[cache_name]
        ATTEMPTS = 1000

        print(f'Running {cache_name}')
        KEY = 'test_me'

        # one-off test ~~~~

        cache.set(KEY, '1')
        cache.get(KEY)

        print('Write benchmark')
        tic = time.time()
        for x in range(ATTEMPTS):
            cache.set(KEY, str(x))

        write_avg = (time.time() - tic) / ATTEMPTS

        print('Read benchmark')

        tic = time.time()
        for _ in range(ATTEMPTS):
            cache.get(KEY)

        read_avg = (time.time() - tic) / ATTEMPTS

        print(f'{cache_name}; READ  {read_avg:2f}; WRITE {write_avg:2f}')


"""
redis_test; READ  0.000200; WRITE 0.003711 (тот же дц)
Running locmem_test
Write benchmark
Read benchmark
locmem_test; READ  0.000014; WRITE 0.000017
Running memcached_test
Write benchmark
Read benchmark
memcached_test; READ  0.000050; WRITE 0.000056
Running mongodb_test
Write benchmark
Read benchmark
mongodb_test; READ  0.000698; WRITE 0.020011
Running mongodb_test_nwc
Write benchmark
Read benchmark
mongodb_test_nwc; READ  0.000713; WRITE 0.000319
"""
