
import time

from wiki.utils.injector import thread_locals

REMEMBER_CELERY_BROKER_UNAVAILABILITY_FOR = 5  # 5 секунд помним, что брокер Celery недоступен

thread_locals.celery_broker_unavailable_since = None


def celery_broker_was_unavailable():
    return getattr(thread_locals, 'celery_broker_unavailable_since', None) is not None


def celery_broker_maybe_available():
    return (
        getattr(thread_locals, 'celery_broker_unavailable_since', None) is not None
        and time.time() - thread_locals.celery_broker_unavailable_since > REMEMBER_CELERY_BROKER_UNAVAILABILITY_FOR
    )  # noqa


def set_celery_broker_unavailable():
    thread_locals.celery_broker_unavailable_since = time.time()


def set_celery_broker_available():
    thread_locals.celery_broker_unavailable_since = None
