from typing import Generic, TypeVar

T = TypeVar('T')


class ContextBoundSerializer(Generic[T]):
    def __init__(self, *args, **kwargs):
        """
        Должен идти первым.
        :param args:
        :param kwargs:
        """
        # noinspection PyPep8Naming
        Klass = self.__orig_bases__[0].__args__[
            0
        ]  # немного грязное решение чтобы из дженерика и тайпхинта получить класс
        if not isinstance(kwargs.get('context'), dict):
            raise ValueError(f'Must provide context=... that resolves to {Klass}')

        self._typed_context = Klass(**kwargs.get('context'))
        super().__init__(*args, **kwargs)

    def get_context(self) -> T:
        return self._typed_context
