import base64

from cryptography.fernet import Fernet
from cryptography.hazmat.backends import default_backend
from cryptography.hazmat.primitives import hashes
from cryptography.hazmat.primitives.kdf.pbkdf2 import PBKDF2HMAC
from django.utils.encoding import smart_bytes


def generate_fernet_key(str_key, salt):
    secret_str = smart_bytes(str_key)
    kdf = PBKDF2HMAC(algorithm=hashes.SHA256(), length=32, salt=salt, iterations=100000, backend=default_backend())
    return base64.urlsafe_b64encode(kdf.derive(secret_str))


def encrypt_string(string_, key):
    f = Fernet(key)
    return f.encrypt(smart_bytes(string_))


def decrypt_string(string_, key):
    f = Fernet(key)
    return f.decrypt(smart_bytes(string_))
