from collections import namedtuple

from django.conf import settings
from django.db import models, transaction
from django.db.models.lookups import IContains


def on_commit(callback):
    if settings.IS_TESTS:
        callback()
    else:
        transaction.on_commit(callback)


def namedtuple_fetchall(cursor):
    "Return all rows from a cursor as a namedtuple"
    desc = cursor.description
    nt_result = namedtuple('Result', [col[0] for col in desc])
    return [nt_result(*row) for row in cursor.fetchall()]


class PostgreILike(IContains):
    lookup_name = 'ilike'

    def as_postgresql(self, compiler, connection):
        lhs, lhs_params = self.process_lhs(compiler, connection)
        rhs, rhs_params = self.process_rhs(compiler, connection)
        params = lhs_params + rhs_params
        return '%s ILIKE %s' % (lhs, rhs), params


models.CharField.register_lookup(PostgreILike)
models.TextField.register_lookup(PostgreILike)
