"""
Wrapper around dict that makes it behave like Django cache object. Be careful
because it doesn't fully implement interface for cache backends.
"""


class DictCache(dict):
    def get(self, key, default=None, version=None):
        return super(DictCache, self).get(key, default)

    def set(self, key, value, timeout=None, version=None):
        self[key] = value
