from docx.shared import RGBColor


class Color:
    RED = 0
    BLUE = 1
    GREEN = 2
    GRAY = 3
    YELLOW = 4

    CONST_2_STR = {
        RED: 'red',
        BLUE: 'blue',
        GREEN: 'green',
        GRAY: 'gray',
        YELLOW: 'yellow',
    }

    @staticmethod
    def str(v):
        return Color.CONST_2_STR[v]


WIKI_COLOR_TO_RGB = {
    Color.RED: RGBColor(0xCC, 0, 0),
    Color.GREEN: RGBColor(0, 0x80, 0),
    Color.BLUE: RGBColor(0, 0x44, 0xBB),
    Color.GRAY: RGBColor(0x80, 0x80, 0x80),
    Color.YELLOW: RGBColor(0xFF, 0xD7, 0),
}

DEFAULT_REMARK_COLOR = Color.RED

DEFAULT_DOC_COLOR = RGBColor(0, 0, 0)

# Цвет текста из .docx документа должен быть
# не дальше от вики-цвета, чем эта констанса,
# чтобы присвоить вики-разметке данный вики-цвет.
MAX_DISTANCE_TO_WIKI_COLOR = 0x70


def get_rgb_color_by_wiki_color(wiki_color):
    return WIKI_COLOR_TO_RGB[wiki_color]


def get_closest_wiki_color(color):
    if color is None or color.rgb is None or color == DEFAULT_DOC_COLOR:
        return None

    closest_wiki_color, min_distance = None, MAX_DISTANCE_TO_WIKI_COLOR
    for wiki_color, wiki_rgb in WIKI_COLOR_TO_RGB.items():
        distance = 0
        for i in range(3):
            distance += abs(wiki_rgb[i] - color.rgb[i])
        if distance < min_distance:
            closest_wiki_color = wiki_color
            min_distance = distance

    return Color.str(closest_wiki_color) if closest_wiki_color is not None else None
