__author__ = 'chapson'

from urllib.parse import quote

from django.conf import settings

from wiki.files.models import File


def file_id(page_supertag, file_url):
    return page_supertag + '/' + file_url


BROWSER_VIEWABLE_EXTENSIONS = {'jpg', 'jpeg', 'gif', 'png', 'bmp', 'swf'}


def docviewer_preview_link(file, dir_org_id=None):
    pos = file.url.rfind('.')
    if pos > -1:
        extension = file.url[pos + 1 :].lower()
        if extension in BROWSER_VIEWABLE_EXTENSIONS:
            return File.full_path(file.page.url, file.url)
    return link_to_docviewer(file, dir_org_id)


def link_to_docviewer(file, dir_org_id=None):
    wiki = 'ya-wiki://%s/%s' % (settings.API_WIKI_HOST, file_id(file.page.supertag, file.url))

    if dir_org_id:
        wiki = '%s?%s' % (wiki, dir_org_id)
    return 'https://%s/?url=%s' % (settings.DOCVIEWER_HOST, quote(wiki))
