
import logging

import yenv

logger = logging.getLogger(__name__)

YANDEXOID_ALIAS_TYPE = '13'
ORGANIZATIONS_ALIAS_TYPE = '1017'

# захардкоженные UID-ы внешних тестовых пользователей, кто является сотрудниками Яндекса
YANDEXOID_ACCOUNTS = [
    4029389376,  # am-elisei
    4022949630,  # olivertouchwood
    4038770804,  # quickjustice
    4039791870,  # wiki-test
]


def is_yastaff(yauser):
    if not yauser.is_authenticated():
        return False
    if yenv.type != 'production' and yauser.uid in YANDEXOID_ACCOUNTS:
        # костыль для тестинга, чтобы проверить яндексоидов с внешними учетками
        return True
    try:
        fields = getattr(yauser, 'fields', {})
        aliases = fields.get('aliases', [])
        if isinstance(aliases, dict):
            # в зависимости от инстанса BB (XmlBlackbox или JsonBlackbox) в aliases может быть
            # или dict: {u'1': u'am-elisei', u'13': u'elisei'}, или list: [('1', 'am-elisei')]
            aliases = list(aliases.items())
        return any(key == YANDEXOID_ALIAS_TYPE for key, value in aliases)
    except Exception:
        logger.exception('Can\'t get user aliases')
        return False


def get_user_orgs_from_blackbox(yauser):
    try:
        fields = getattr(yauser, 'fields', {})
        attributes = fields.get('attributes', {})  # {u'1017': u'3295249,3668647'}
        if isinstance(attributes, list):
            attributes = dict(attributes)
        orgs_str = attributes.get(ORGANIZATIONS_ALIAS_TYPE)
        return orgs_str.split(',') if orgs_str else []
    except Exception:
        logger.exception('Can\'t get user orgs')
        return []
