class ValidationError(Exception):
    def __init__(self, invalid_value, message=''):
        self.invalid_value = invalid_value
        self.message = message

    def __repr__(self):
        return "ValidationError: value=%s, message='%s'" % (repr(self.invalid_value), self.message)

    def __str__(self):
        return self.__repr__()


class ApiRequestFailed(Exception):
    pass


class ApiRequestBadRequest(ApiRequestFailed):
    def __init__(self, data=None):
        self.data = data


class ApiRequestForbidden(ApiRequestFailed):
    def __init__(self, data=None):
        self.data = data


class ApiRequestWorkerFatal(ApiRequestFailed):
    def __init__(self, data=None):
        self.data = data


class ApiRequestNotFound(ApiRequestFailed):
    pass


class InputValidationError(AssertionError):
    """
    Пользователь ввел данные, которые не проходят валидацию.
    Используется в том случае, когда текст ошибки предназначен для показа пользователю.
    """

    pass
