from django.conf import settings
from wiki.utils.features.models import WikiFeatures


def get_wiki_features() -> WikiFeatures:
    if get_wiki_features.overriden_features:
        return get_wiki_features.overriden_features
    return settings.FEATURES


"""
Функции для тестов
"""

get_wiki_features.overriden_features = None


def override_wiki_features(q: WikiFeatures):
    get_wiki_features.overriden_features = q


def clear_override_wiki_features():
    get_wiki_features.overriden_features = None
