import re
from collections import defaultdict
from datetime import datetime

from django.conf import settings

if settings.IS_INTRANET:
    from wiki.intranet.models import Group
    from wiki.intranet.models import Office

from wiki.pages.models import Page
from wiki.utils.supertag import normalize_supertag

comment_re = re.compile(r'%%\(comment\)(.*?)%%', re.MULTILINE)
include_re = re.compile(r'{{include\s+(.*?)}}', re.MULTILINE)


def update_homepage(slug='homepage', dry_run=True):
    val = compile_homepage(slug)
    print(val)

    if not dry_run:
        p = Page.objects.get(supertag='homepage/spa')
        p.body = val
        p.save()


def compile_homepage(slug='homepage', offset=''):
    # lets gather countries and pages
    slug = normalize_supertag(slug)
    page = Page.objects.get(supertag=slug)

    includes = defaultdict(list)
    bits = []

    bits.append('// -------------------------------------\n')
    bits.append(f'// Homepage complied at {datetime.now()}\n')
    bits.append('// -------------------------------------\n')

    for match in include_re.findall(page.body):
        page = re.findall('page="(.*?)"', match)[0]
        cases = re.findall('if_(.*?)="(.*?)"', match)
        slug = normalize_supertag(page)
        case, val = cases[0]
        includes[(slug, case)].append(val)

    for (slug, case), vals in includes.items():
        bits.append(f'#if {case}={",".join(vals)} // >>> --- {slug} \n')
        s = compile_subpage(slug, offset + '...')
        bits.append(s.strip() + '\n')
        bits.append(f'#endif // <<<< --- {page} \n')

    return ''.join(bits)


def compile_subpage(slug='homepage', offset=''):
    slug = slug.replace('https://wiki.yandex-team.ru/', '')
    slug = normalize_supertag(slug)
    page = Page.objects.get(supertag=slug)

    print(f'{offset} Page {slug}')
    b = page.body
    b = comment_re.sub('', b)
    match = include_re.search(b)
    bits = []
    last_anchor = 0

    while match:
        bits.append(b[last_anchor : match.start()])
        last_anchor = match.end()

        page = re.findall('page="(.*?)"', match.group(0))[0]
        cases = re.findall('if_(.*?)="(.*?)"', match.group(0))
        if cases:
            for case, val in cases:
                if case == 'group':
                    grp = Group.objects.filter(url=val).first()
                    if grp:
                        val = grp.id
                    else:
                        val = -1

                if case == 'office':
                    grp = Office.objects.filter(code=val).first()
                    if grp:
                        val = grp.id
                    else:
                        val = -1

                bits.append(f'#if {case}={val} // >>> --- {page} \n')

        s = compile_subpage(page, offset + '...')

        bits.append(s.strip() + '\n')

        if cases:
            bits.append(f'#endif // <<<< --- {page} \n')

        match = include_re.search(b, pos=match.end())

    bits.append(b[last_anchor:])
    return ''.join(bits)
