
inflections = {
    'subjective': 0,
    'nominative': 0,
    'genitive': 1,
    'dative': 2,
    'accusative': 3,
    'ablative': 4,
    'instrumental': 4,
    'prepositional': 5,
}


def inflect(i_string, inflection):
    """
    Get particular inflection from inflections string
    @param i_string: string of inflections separated by |, e.g.
                     страница|страницы|странице|страницу|страницей|странице
    @param inflection: inflection's name from _inflections

    >>> inflect(
    ...     'страница|страницы|странице|страницу|страницей|странице'.decode('utf-8'),
    ...     'accusative'
    ... )
    u'\\u0441\\u0442\\u0440\\u0430\\u043d\\u0438\\u0446\\u0443'
    """
    infls = i_string.split('|')
    if len(infls) == 1:
        return infls[0]
    try:
        return infls[inflections[inflection]]
    except KeyError:
        raise ValueError('Unsupported inflection: ' + inflection)
    except IndexError:
        raise ValueError('Bad translation (wrong number of inflections): ' + i_string)


if __name__ == '__main__':
    import doctest

    doctest.testmod()
