

from enum import Enum
from functools import partial
from json import dumps as lib_dumps
from json import loads

from django.core.serializers.json import DjangoJSONEncoder


class ExtendedJSONEncoder(DjangoJSONEncoder):
    def default(self, o):
        if isinstance(o, Enum):
            return o.value
        elif isinstance(o, set):
            return list(o)
        else:
            return super().default(o)


dumps = partial(lib_dumps, cls=ExtendedJSONEncoder)


def cleanup(obj):
    return loads(dumps(obj))
