
import re

from six import string_types

PATH_RE = re.compile(r'^(?P<path>\w+)(\[(?P<idx>\d+)\])?$')


def get_from_json(path_parts, dict_val, default=None):
    try:
        return resolve_json_path(path_parts, dict_val)
    except KeyError:
        return default


def resolve_json_path(path_parts, dict_val):
    """
    Получить из вложенного словаря (например полученного из json)
    attr.attr2.attr3[0] => dict_val['attr']['attr2']['attr3'][0]

    @param path_parts:
    @param dict_val:
    @return:
    """
    if isinstance(path_parts, string_types):
        path_parts = path_parts.split('.')

    for part in path_parts:
        m = PATH_RE.match(part).groupdict()
        if isinstance(dict_val, dict):
            dict_val = dict_val[m['path']]
            if m['idx'] is not None:
                dict_val = dict_val[int(m['idx'])]
        else:
            raise KeyError  # это означает что в словаре мы попали на конечный элемент, а xpath еще не закончился

    return dict_val
