from django.conf import settings

from wiki.api_v2.exceptions import QuotaExceeded


class BillingStubLimit:
    def __init__(self):
        pass

    def exceeded(self, addition, organization=None):
        return False

    def get(self):
        return None


if settings.IS_BUSINESS:
    from wiki.billing import RESTRICTION_NAMES
    from wiki.billing.logic import BillingLimit

    limit__page_num = BillingLimit(RESTRICTION_NAMES.org_page_num)
    limit__attach_size = BillingLimit(RESTRICTION_NAMES.org_attach_size_mb)
    limit__user_max_rev_num = BillingLimit(RESTRICTION_NAMES.user_max_rev_num)
else:
    limit__page_num = BillingStubLimit()
    limit__attach_size = BillingStubLimit()
    limit__user_max_rev_num = BillingStubLimit()


def assert_has_quota(organization):
    if limit__page_num.exceeded(1, organization=organization):
        raise QuotaExceeded()
