import time

from django.core.cache import BaseCache  # noqa
from django.core.cache import caches

log_debounce_cache = caches['default']  # type: BaseCache


class LogDebouncer(object):
    def __init__(self, name, duration_sec):
        self.cache_key = 'log_debounce_%s' % name
        self.duration_sec = duration_sec

    def trigger(self):
        dt = log_debounce_cache.get(self.cache_key)
        now = time.time()
        if dt is None or now - int(dt) > self.duration_sec:
            log_debounce_cache.set(self.cache_key, now)
            return True

        return False
