
import logging


class ReduceClutterFilter(logging.Filter):
    def __init__(self, ruleset):
        super(ReduceClutterFilter, self).__init__()
        self.ruleset = ruleset

    def update_level(self, record, levelno):
        """
        @param record: LogRecord
        @param levelno:
        @return:
        """
        record.levelno = levelno
        record.levelname = logging.getLevelName(levelno)

    def filter(self, record):
        """
        @param record: LogRecord
        @return: int (0 / 1)
        """

        if record.name in self.ruleset and record.levelno in self.ruleset[record.name]:
            self.update_level(record, self.ruleset[record.name][record.levelno])

        return 1
