

def missing_primary_keys(model_query_set, pks, id_attr_name='pk'):
    """
    Возвращает primary keys, которых нет среди model_query_set.

    QuerySet - ленивый. После вызова этой функции будет выполнен запрос в базу,
    если еще не был выполнен. Т.е. если QuerySet еще не был evaluated, то
    будет выполнен запрос в базу.

    @rtype: set
    """
    exists = {getattr(model, id_attr_name) for model in model_query_set}

    # Нужно чтобы типы значений в обоих множествах были одинаковые
    cast_to = str
    if any({isinstance(pk, int) for pk in exists}):
        cast_to = int

    return {cast_to(pk) for pk in pks} - exists
