
import logging

from django.conf import settings
from django.core.cache import caches
from django.core.management import BaseCommand

logger = logging.getLogger('management_commands.tmp_api_documentation')


def mongodb_cache_names():
    for cache_name, cache_setting in settings.CACHES.items():
        if cache_setting['BACKEND'].endswith('MongoDBCache'):
            yield cache_name


def drop_collection(cache_name):
    caches[cache_name].collection().drop()


class Command(BaseCommand):
    help = 'Drop all those collections in mongodb, which contain cache.'
    requires_system_checks = False

    def handle(self, *args, **options):
        for cache_name in mongodb_cache_names():
            drop_collection(cache_name)
