
import logging

from django.core.management import BaseCommand

from wiki.pages.models import Page, Revision

log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = 'Fix broken MDS ids'
    requires_system_checks = False

    def handle(self, *args, **options):
        for page in Page.objects.filter(mds_storage_id__isnull=False):
            revision_mds_storage_qs = Revision.objects.filter(page_id=page.id).order_by('id')
            revision_mds_storage_id = revision_mds_storage_qs.values_list('mds_storage_id', flat=True).last()
            if revision_mds_storage_id:
                Page.objects.filter(id=page.id).update(mds_storage_id=revision_mds_storage_id)
