import os

from django.core.management import call_command
from django.core.management.base import BaseCommand
from wiki.utils.po_check import check_translation_integrity


def ensure_locale_dirs():
    """
    Создать все необходимые папки с локалями если еще не.
    """
    for lang in ('en', 'ru'):
        locale_path = 'locale/{0}/LC_MESSAGES'.format(lang)
        if not os.path.exists(locale_path):
            os.makedirs(locale_path)

        with open(f'{locale_path}/django.po', 'w'):
            pass


IPYTHON_CFG = """# Configuration file for ipython.
try:
    c.InteractiveShellApp.exec_lines = ['from wiki.ipython_startup import *']  # noqa
except NameError:
    pass
"""


class Command(BaseCommand):
    requires_system_checks = False

    def handle(self, **options):
        """
        В Аркадии нет инвоука, поэтому эта команда заменяет вот эти:

        invoke -r / collect-static \
        invoke -r / check-po-files
        """
        ensure_locale_dirs()
        call_command('collectstatic')

        os.makedirs('/wiki_ipython', exist_ok=True)

        with open('/wiki_ipython/ipython_config.py', 'w') as wf:
            wf.write(IPYTHON_CFG)

        check_translation_integrity()
