
import sys
from datetime import datetime

import yenv
from django.core.management import BaseCommand
from django.db import transaction
from django.db.models import Q

from wiki.favorites_v2.models import Folder
from wiki.pages.models import Page
from wiki.personalisation.user_cluster import personal_cluster
from wiki.users.models import Group

IMPORTANT_CLUSTERS = [
    'homepage',
    'vodstvo',
    'settings',
    'wiki',
]


class Command(BaseCommand):
    requires_system_checks = False

    def handle(self, *args, **options):
        if yenv.type == 'production':
            sys.stderr.write('I will not work in production environment\n')
            sys.exit(1)

        # delete pages and related shit
        personal_clusters = list(self.get_personal_clusters())
        root_supertags = IMPORTANT_CLUSTERS + personal_clusters
        print(root_supertags)

        regex = '^(' + '|'.join(root_supertags) + ')(/.+)?'
        good_pages = Page.objects.filter(supertag__regex=regex)
        bad_pages = Page.objects.exclude(supertag__regex=regex)

        print('Good pages count:' + str(good_pages.count()))
        print('Delete ' + str(bad_pages.count()) + ' pages')

        for num, page in enumerate(bad_pages.order_by('id')):
            print(datetime.now().isoformat(), 'deleting', page.id, page.supertag)
            page.delete()
            if num % 100 == 0:
                print(num, 'commit')
                transaction.commit()

        print('Now we have %s pages' % Page.objects.count())

        # delete folders and bookmarks
        folders = Folder.objects.all()
        print('Folders count: ' + str(folders.count()))

        wiki_team_users = [m.user for m in self.get_wiki_team()]
        wiki_team_folder = folders.filter(user__in=wiki_team_users)
        print('Wiki team folders count: ' + str(wiki_team_folder.count()))

        for num, folder in enumerate(folders.exclude(user__in=wiki_team_users)):
            print(folder)
            folder.delete()
            if num % 100 == 0:
                print(num, 'commit')
                transaction.commit()

        print('Folders count: ' + str(folders.count()))

    @classmethod
    def get_personal_clusters(cls):
        # TODO: save redirects-pages to this clusters
        for member in cls.get_wiki_team():
            try:
                cluster = personal_cluster(member.user)
            except Exception as e:
                print(str(e))
                continue
            yield cluster.supertag

    @staticmethod
    def get_wiki_team():
        groups = Group.objects.filter(
            Q(service_id=287) | Q(department_id=1718)  # сервис Вики  # человекоподобные роботы
        )
        for group in groups:
            for member in group.all_members:
                yield member
