
from django.core.management.base import BaseCommand
from django.db import transaction

from wiki.notifications.models import PageEvent
from wiki.pages.models import Revision


class Command(BaseCommand):
    help = 'Restore author of every revision'
    requires_system_checks = False

    def handle(self, *args, **options):
        revision_ids = Revision.objects.filter(author=None).values_list('id', flat=True)
        for rev_id in revision_ids:
            with transaction.atomic():
                revision = Revision.objects.select_related('page').get(id=rev_id)
                # Пытаемся найти PageEvent с заданной ревизией.
                for page_event in PageEvent.objects.filter(page=revision.page):
                    if 'revision_id' not in page_event.meta:
                        continue
                    if page_event.meta['revision_id'] != revision.id:
                        continue
                    revision.author = page_event.author  # это поле всегда заполнено
                    break
                if not revision.author_id:  # не нашли page_event
                    # проставляем автором ревизии владельца страницы.
                    # Это может вызвать недостоверность в базе - автором правки
                    # будет считаться какой-то произвольный польователь
                    revision.author = revision.page.get_authors().first()
                revision.save()
