

from django.conf import settings
from django.core.management.base import BaseCommand
from django.db import connection, transaction


class Command(BaseCommand):
    requires_model_validation = False

    @transaction.atomic()
    def handle(self, *args, **options):
        c = connection.cursor()
        c.execute(
            'SELECT table_name, constraint_name FROM information_schema.table_constraints '
            "WHERE table_catalog='{0}' AND constraint_name LIKE '%_fkey'".format(settings.DATABASES['default']['NAME'])
        )

        for table_name, constraint_name in c.fetchall():
            c.execute(
                'ALTER TABLE %(table)s ALTER CONSTRAINT %(constraint)s DEFERRABLE INITIALLY DEFERRED'
                % {'table': table_name, 'constraint': constraint_name}
            )
