

from django.conf import settings
from django.core.management.base import BaseCommand
from django.db import connection, transaction


class Command(BaseCommand):
    requires_model_validation = False

    @transaction.atomic()
    def handle(self, *args, **options):
        c = connection.cursor()
        c.execute(
            "select table_name, column_name, data_type from INFORMATION_SCHEMA.COLUMNS where data_type LIKE '%without%'"
            "AND table_catalog='{0}'".format(settings.DATABASES['default']['NAME'])
        )

        for line in c.fetchall():
            c.execute(
                "ALTER TABLE %(table)s ALTER %(column)s TYPE timestamptz USING %(column)s AT TIME ZONE 'UTC';"
                % {'table': line[0], 'column': line[1]}
            )
