
from django.core.management.base import BaseCommand

from wiki.pages.logic.redirect import remove_redirect
from wiki.pages.models import Page
from wiki.utils.wiki_robot import get_wiki_robot


def unredirect_pages_in_cluster(cluster):
    redirects = Page.active.filter(
        redirects_to__isnull=False,
        supertag__startswith='%s/' % cluster,
    )

    robot_vika = get_wiki_robot()

    for redirect in redirects:
        print('Unredirecting "%s"' % redirect.supertag)
        remove_redirect(redirect, robot_vika.user)

    if len(redirects) > 0:
        print('%d pages unredirected' % len(redirects))
    else:
        print('No redirects in cluster or no such cluster: "%s"' % cluster)


class Command(BaseCommand):
    help = """Unredirect (change page type back from redirect to page/grid) all redirect pages in cluster"""

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--cluster',
            '-c',
            action='store',
            dest='cluster',
            default=None,
            help='The cluster in which pages will be unredirected',
        )

    def handle(self, *args, **options):
        if options.get('cluster'):
            cluster = options['cluster']
        else:
            print('Error: --cluster parameter is required')
            return
        unredirect_pages_in_cluster(cluster)
