
import logging
import sys

import yenv
from django.core.management import BaseCommand

from wiki.users.models import Group

logger = logging.getLogger('management_commands.tmp_api_documentation')


class Command(BaseCommand):
    help = 'Make members of wiki-team superusers in django-admin.'
    requires_system_checks = False

    def handle(self, *args, **options):
        if yenv.type == 'production':
            sys.stderr.write('I will not work in production environment\n')
            sys.exit(1)
        verbosity = int(options.get('verbosity'))
        group = Group.objects.get(service_id=287)  # сервис Вики
        for staff in group.all_members:
            if verbosity:
                print('processing user {0}'.format(staff.user))
            staff.user.is_superuser = True
            staff.user.is_staff = True
            staff.user.save()
