
from django.utils.html import escape

from wiki.utils.diff import DifflibDiff
from wiki.utils.timer import track_time

_diff = DifflibDiff()
_smart_diff = DifflibDiff(unchanged_lines_count=5)


@track_time
def get_marked_diff_text(text1, text2, skip_unchanged_lines=False):
    """
    Вернуть текст, показывающий различия между двумя исходными текстами.
    Текст разбить на строки и каждую строку, в зависимости от содержащихся различий,
    пометить признаком принадлежности к одному из трех типов: both, del, ins.
    @rtype: list
    """
    diff = _smart_diff if skip_unchanged_lines else _diff

    text = []
    for line in diff.diff_texts(escape(text1), escape(text2)).split('\n'):
        is_del, is_ins = False, False
        if '<del>' in line:
            is_del = True
        if '<ins>' in line:
            is_ins = True
        if is_del and is_ins:
            cls = 'both'
        elif is_del:
            cls = 'del'
        elif is_ins:
            cls = 'ins'
        else:
            cls = None
        text.append({'txt': line, 'class': cls})

    return text
