
from django.conf import settings
from urllib3.util import parse_url

from wiki.utils import api_request

COUNTER_ID = settings.COUNTER_ID
OAUTH_TOKEN = settings.METRIKA_OAUTH_TOKEN
API_URL = settings.METRIKA_API_URL


def get_top_pages(limit=10, offset=1):
    params = {
        'id': COUNTER_ID,
        'oauth_token': OAUTH_TOKEN,
        'pretty': 1,
        'metrics': 'ym:pv:pageviews',
        'sort': '-ym:pv:pageviews',
        'accuracy': 'high',
        'dimensions': 'ym:pv:URL',
        'date1': '31daysAgo',
        'date2': 'today',
        'offset': offset,
        'limit': limit,
    }

    headers = {
        'Host': 'api-metrika.yandex.ru',
        'Content-Type': 'application/x-yametrika+json',
    }

    response = api_request.get(
        url=API_URL,
        oauth_token=OAUTH_TOKEN,
        params=params,
        headers=headers,
    )

    data = response.json()['data']
    for row in data:
        yield row['dimensions'][0]['name']


def get_supertag_from_url(url):
    path = parse_url(url).path.lower()
    if path.startswith('/'):
        path = path[1:]
    if path.endswith('/'):
        path = path[:-1]

    return path
