
from django.conf import settings
from pymongo import MongoClient

_mongo_client = None


def get_mongo_client():
    global _mongo_client
    if _mongo_client is None:
        _mongo_client = MongoClient(settings.MONGO_CONNECTION_URL, tz_aware=True)[settings.MONGO_DATABASE]
    return _mongo_client
