

from functools import partial

from django.conf import settings
from django.core.cache import caches
from ids.helpers import oauth

tokens_cache = caches['oauth_tokens']

get_token_by_uid = partial(
    oauth.get_token_by_uid,
    settings.OAUTH_ID,
    settings.OAUTH_SECRET,
)

get_token_by_password = partial(
    oauth.get_token_by_password,
    settings.OAUTH_ID,
    settings.OAUTH_SECRET,
)

get_token_by_sessionid = partial(
    oauth.get_token_by_sessionid,
    settings.OAUTH_ID,
    settings.OAUTH_SECRET,
    host=settings.NGINX_HOST,
)


def get_token_by_user_auth(user_auth):
    """
    Эта функция рекомендована к использованию, потому что кеширует токены.
    """
    uid = user_auth.uid
    sessionid = user_auth.sessionid
    token = tokens_cache.get(uid)
    if token is None:
        token = get_token_by_sessionid(sessionid=sessionid)
        tokens_cache.set(uid, token)
    return token
