"""
    This module provides decorator 'optional_kwargs' that helps creating
    other decorators that may have optional kwargs. Hmmmm... See tests
    to get the idea.
"""

from functools import partial


def optional_kwargs(deco):
    def metadeco(function=None, **kwargs):
        if function is None:
            return partial(deco, **kwargs)
        return deco(function, **kwargs)

    return metadeco
