

from django.conf import settings
from ids.registry import registry

from wiki.utils.tvm2 import get_service_ticket

PLANNER_CONNECTION_TIMEOUT = 2


def get_planner_repository(resource_type):
    return registry.get_repository(
        service='abc',
        resource_type=resource_type,
        user_agent='wiki',
        service_ticket=get_service_ticket(settings.ABC_TVM2_CLIENT_ID),
        timeout=PLANNER_CONNECTION_TIMEOUT,
        api_version=4,
        retries=3,
    )


def get_planner_services_repository():
    return get_planner_repository(resource_type='service')


def get_planner_service_members_repository():
    return get_planner_repository(resource_type='service_members')


def get_planner_service_contacts_repository():
    return get_planner_repository(resource_type='service_contacts')
