from django.conf import settings

from wiki.sync.connect.org_ctx import get_org
from django_tools_log_context.provider.base import BaseProvider


class Provider(BaseProvider):
    def org(self):
        if not settings.IS_BUSINESS:
            return None

        try:
            org = get_org(guard_noorg=False)
        except Exception:
            org = None

        return {
            'dir_id': org.dir_id if org else None,
        }
